import { cn } from "@/lib/utils";
import { ReactNode } from "react";
import { DropzoneOptions, DropzoneState, useDropzone } from 'react-dropzone'

export type DropZoneProps = DropzoneOptions & {
    className?: string,
    children?: {
        content?: ReactNode | ((state: DropzoneState) => ReactNode),
        note?: ReactNode | ((state: DropzoneState) => ReactNode),
    }
}

export function DropZone({ className, children, ...dropZoneOptions }: DropZoneProps) {
    const state = useDropzone(dropZoneOptions);
    const { getRootProps, getInputProps, isDragActive, isDragReject, isFocused } = state;

    const { className: dropZoneClassName, ...dropZonePropertiesInternal } = getRootProps({ className: 'dropzone' })

    return (
        <>
            <div className="w-full flex flex-col gap-2">
                <div
                    className={cn(
                        "transition-all border border-border border-dashed rounded-sm text-subtle-foreground ring-2 ring-primary/0 outline-0",
                        dropZoneClassName,
                        className,
                        isDragActive ? "bg-primary/5 text-foreground" : "bg-background",
                        isDragActive || isFocused ? "border-primary/65 bg-primary/5" : "",
                        isDragReject ? "text-red-600 dark:text-red-700 border-red-600 dark:border-red-700 bg-red-600/5 dark:bg-red-700/5" : "",
                    )}
                    {...dropZonePropertiesInternal}
                >
                    <input {...getInputProps()} />

                    {
                        children?.content &&
                        <>
                            {

                                (typeof children.content === 'function'
                                    ? children.content(state)
                                    : children.content
                                )
                            }
                        </>
                    }
                </div>

                {
                    children?.note &&
                    <em
                        className={cn(
                            "transition-colors text-xs text-subtle-foreground",
                            isDragReject ? "text-red-600 dark:text-red-700" : "",
                        )}
                    >
                        {(typeof children.note === 'function'
                            ? children.note(state)
                            : children.note
                        )}
                    </em>
                }
            </div>
        </>
    );
}
